<?php

echo "<pre>";

// Delete cached config files manually
$cacheFiles = [
    __DIR__ . '/../bootstrap/cache/config.php',
    __DIR__ . '/../bootstrap/cache/packages.php',
    __DIR__ . '/../bootstrap/cache/services.php',
];

foreach ($cacheFiles as $file) {
    if (file_exists($file)) {
        unlink($file);
        echo "Deleted: $file\n";
    } else {
        echo "Not found (OK): $file\n";
    }
}

// Delete compiled cache/view files
$framework = __DIR__ . '/../storage/framework/';
$folders = ['cache', 'views'];

foreach ($folders as $folder) {
    $path = $framework . $folder;

    foreach (glob("$path/*") as $file) {
        if (is_file($file)) {
            unlink($file);
            echo "Cleared file: $file\n";
        }
        if (is_dir($file)) {
            echo "Skipped directory: $file\n";
        }
    }
}

echo "\nAll Laravel manual cache files cleared.\n\n";

// -------- RUN ARTISAN OPTIMIZE -------- //

require __DIR__ . '/../vendor/autoload.php';
$app = require_once __DIR__ . '/../bootstrap/app.php';

use Illuminate\Support\Facades\Artisan;

$kernel = $app->make(Illuminate\Contracts\Http\Kernel::class);
$kernel->handle(
    $request = Illuminate\Http\Request::capture()
);

// Run optimize
Artisan::call('optimize');
Artisan::call('migrate', [
    '--force' => true // Required in production
]);

echo "\nArtisan optimize output:\n";
echo nl2br(Artisan::output() ?? '');

echo "\nDone.\n";
