<?php

namespace App\Http\Resources\Lab;

use Illuminate\Http\Resources\Json\JsonResource;

class StiTestResultResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            "id" => $this->id,
            "result_document_url" => $this->result_document_url,
            "status" => $this->status,
            "outcome" => $this->outcome,
            "notes" => $this->notes,
            "created_at" => $this->created_at,
            "updated_at" => $this->updated_at,
            "lab_test_user_id" => $this->lab_test_user_id,
            "lab" => [
                "id" => $this->lab_id,
                "name" => $this->lab_name,
            ],
            "customer" => [
                "id" => $this->customer_id,
                "name" => $this->customer_name,
                "email" => $this->customer_email,
                "avatar" => $this->customer_avatar_url ? url('uploads/profile_images/' . $this->customer_avatar_url) : null,
            ],
            "patient_id" => $this->patient_id,
            "test_date" => $this->test_date,
            "test" => [
                "id" => $this->lab_test_id,
                "name" => $this->test_name,
                "type" => $this->test_type,
            ],
            "category" => [
                "id" => $this->category_id,
                "name" => $this->category_name,
            ],
        ];
    }
}
